// Questp programma e' il modulo DOS che carica sulla scheda DSP il programma
// ARB.DSK, dopodiche' scrive nella memoria della scheda tutti i campioni
// che si trovano nel file "DATI.DAT", e avvia l'esecuzione del programma
// assembly.


// Questo serve per utilizzare la libreria HI5, quella che serve per l'uso
// della scheda tramite programma C
#include "HI5_LIB.H"

// Questo serve per usare le stringhe di caratteri
#include <string.h>

// Questi sono i moduli nostri
#include <carica.h>
#include <func2.h>

// Variabili che fanno parte della libreria HI5
// NON modificare la imr!!!
STRUCT_IMR imr;

// vari parametri come : numero della porta COM, baud rate.....
PARAMETER prm;

// Posizione nello schermo a cui compariranno i messaggi di sistema
extern MSGRx, MSGRy;

extern pcom;                // Numero della porta COM.

// Nome del file di programma da caricare nella scheda ;
// Lo inizializzo soltanto
extern  char appfile[] = "12345678.dsk";


void main(void)
{

  // Indirizzo di partenza del programma assembly del DSP
  const int indirizzoPartenza = 0x0a00;

  // Massimo numero di caratteri di un rigo nel file
  const int maxCar = 80 ;

  // La stringa di appoggio per la lettura dei dati dal file "ingresso"
  char rigo [maxCar] = "" ;

  // Il file da dove prelevo i dati
  FILE* ingresso = NULL ;

  // Numero di campioni presenti nel file (dopo il conteggio)
  int numCamp = 0 ;

  // Indirizzo finale del buffer circolare
  int fineMem = 0xf10;

  // le coppie di valori che verranno lette dal file di ingresso
  double x=0, y=0 ;

  // Indica in quale punto dello schermo devono comparire i messaggi
  // di sistema
  MSGRy=5;

  // cancello lo schermo ; solo che sotto Windows forse non serve.
  clrscr();

  // Imposto la porta seriale su cui e' collegata la scheda ;
  // 0 indica la COM1, e cosi' via.
  prm.com = 0;

  // Imposto il baud rate sulla porta seriale.
  // Se siamo sotto Windows, vedere se questa impostazione fa effetto
  // gia' cosi', oppure bisogna impostare la stessa velocita' tramite
  // pennello di controllo.
  prm.speed = 19200;

  // Imposta la logica di un certo piedino della porta seriale.
  // Pure qui vedere se sotto Windows va tutto bene.
  prm.INVERSE = YES;

  // Indico quale e' il programma assembly da eseguire
  strcpy (appfile, "arb.dsk") ;

  // Qui devo contaggiare il numero di campioni presenti nel file, allora
  // Lo leggo tutto e conto il numero di valori presenti.

  // Apro il file ingresso a sola lettura
  ingresso = fopen ("dati.dat", "r") ;

  // Un controllo molto grezzo, ma per ora vado cosi'....
  if (ingresso == NULL)
  {
     printf ("Il file di ingresso non si e' aperto!!!!\n") ;
     exit (0) ;
  }// end if

  // Finche' ci sono dati...
  while (!feof (ingresso))
  {
     // Svuoto il rigo di appoggio
     strcpy (rigo,"") ;

     // Leggo una riga dal file
     fgets (rigo, maxCar, ingresso) ;

     // Solo se questa riga non e' vuota...
     if ( strlen (rigo) > 2 )
     {
	// Incremento il numero di campioni
	numCamp++ ;
     }// end if

  }// end while

  // Chiudo il file di ingresso
  fclose (ingresso) ;

  // Faccio vedere il numero di campioni appena conteggiato
  printf ("Il numero di campioni nel file e' : %d\n", numCamp) ;

  // Un controllo molto grezzo, ma per ora vado cosi'....
  if (numCamp > numCampMax)
  {
     printf ("Il numero di campioni supera la memoria disponibile su scheda!\n") ;
     exit (0) ;
  }// end if


  // Inizializzo la scheda e carico il programma assembly
  initScheda () ;

  // Calcolo la fine del buffer circolare del DSP
  fineMem = inizioMem + numCamp -1 ;

  // E lo invio alla scheda.
  sendcommand (LD, CBER1, 1);
  sendword (fineMem) ;

  printf ("\nAttendere il caricamento dei campioni nella memoria del DSP.\n") ;

  // Adesso scrivo i dati nella memoria della scheda
  // Preparo il trasferimento del giusto numero di campioni
  sendcommand (LD, inizioMem, numCamp);

  // Apro il file ingresso a sola lettura
  ingresso = fopen ("dati.dat", "r") ;

  // Un controllo molto grezzo, ma per ora vado cosi'....
  if (ingresso == NULL)
  {
     printf ("Il file di ingresso non si e' aperto!!!!\n") ;
     exit (0) ;
  }// end if

  // Finche' ci sono dati...
  while (!feof (ingresso))
  {
     // Svuoto il rigo di appoggio
     strcpy (rigo,"") ;

     // Leggo una riga dal file
     fgets (rigo, maxCar, ingresso) ;

     // La Scandisco solo se questa riga non e' vuota
     if ( strlen (rigo) > 2 )
     {
	// Converto in numeri i valori presenti nel rigo
	sscanf (rigo, "%lf %lf", &x, &y) ;

	// Faccio la solita stampa di controllo
	printf ("Le coppie in numerico valgono :  %lf    %lf\n",x,y) ;

	// Invio il campione alla scheda
	sendword (toNumDac (y) );

	// Notare che la "x" non serve a niente ; solo che nel file
	// ci sono coppie di valori....
     }// end if

  }// end while

  // Chiudo il file di ingresso
  fclose (ingresso) ;

  printf ("\nCaricamento terminato.\n") ;

  // Faccio partire il programma appena caricato
  FreeRun (indirizzoPartenza);
  printf("\nIl DSP  stato avviato e genera la forma d'onda voluta \n\n");

}// end main



// Funzione da chiamare tutte le volte che si deve caricare un nuovo
// programma nel DSP.
void initScheda ()
{
      // Inizializza il contatore di programma del DSP al primo
      // indirizzo disponibile della memoria di programma
      prm.PGM_CNT = 0x980;

      // Inizializza il software per la comunicazione tra PC e scheda
      InitializeMonitor();

      // Carica sulla scheda il programma voluto
      LoadDsk();

      // Inizializza tutti i registri interni del DSP
      InitRegister(YES);
}// end initScheda
